﻿var a4 = {
    baseUrl: null,
    host: null,
    lastError: null,
    onAjaxPageMethodError: function (xhr, msg, e) {
        window.clearTimeout(a4.ajaxRequestTimer);
        a4.ajaxRequestInProcess = false;
        $("body").removeClass("wait");
        a4.hideBusyBox();

        if (xhr.status != 200 || xhr.responseText.length > 0) {
            var error = eval("(" + xhr.responseText + ")");
            a4.lastError = error;
            a4.showErrorMessage(error);
        }
    },
    callServerMethod: function (action, data, onSuccess, onError, additionalSettings) {
        var args = '';
        var blockElementTimer;
        if (data !== undefined && data !== null) {
            args = data;
        }

        if (a4.ajaxPendingCalls == 0) {
            if (a4.busyBoxEnabled) {
                a4.ajaxRequestTimer = setTimeout(function () { a4.showBusyBox(); }, a4.busyBoxTimeout);
            }

            $("body").addClass("wait");
            a4.ajaxRequestInProcess = true;
        }

        a4.ajaxPendingCalls++;
        var settings = additionalSettings || {};

        var blockElement = settings.blockElement || null;
        var blockElementTimeout = settings.blockElementTimeout != undefined ? settings.blockElementTimeout : 800;

        if (blockElement) {
            blockElementTimer = setTimeout(function () {
                blockElement.block({
                    message: " ",
                    css: { width: '16px' },
                    overlayCSS: { backgroundColor: '#AAA', opacity: 0.5 }, // Remove coma at the end ... Uncompatile with compatibilty view
                    fadeIn: 0,
                    fadeOut: 0,
                    ignoreIfBlocked: true
                });
            }, blockElementTimeout);
        }

        var customCompleteFunction = null;
        if (typeof additionalSettings !== "undefined" && additionalSettings.complete) {
            var customCompleteFunction = additionalSettings.complete;
        }

        settings.type = settings.type || "POST";
        settings.url = action;
        settings.data = settings.data || JSON.stringify(args);
        settings.contentType = settings.contentType || "application/json; charset=utf-8";
        settings.dataType = settings.dataType || "json";
        settings.success = onSuccess;
        settings.error = onError || a4.onAjaxPageMethodError;
        settings.complete = function (data, textStatus) {
            if (blockElement) {
                window.clearTimeout(blockElementTimer);
                blockElement.unblock();
            }

            a4.ajaxPendingCalls--;

            if (a4.ajaxPendingCalls == 0) {

                if (a4.ajaxRequestTimer != null) {
                    window.clearTimeout(a4.ajaxRequestTimer);
                }

                a4.ajaxRequestInProcess = false;
                $("body").removeClass("wait");

                if (a4.busyBoxEnabled) {
                    a4.hideBusyBox();
                }
            }

            if (customCompleteFunction) {
                customCompleteFunction(data, textStatus);
            }

        }

        return $.ajax(settings);
    },
    ajaxPendingCalls: 0,
    ajaxRequestInProcess: false,
    ajaxRequestTimer: null,
    busyBoxEnabled: false,
    busyBoxTimeout: 2000,
    showBusyBox: function () {
        $.blockUI({
            css: {
                border: 'none',
                padding: '15px',
                backgroundColor: '#000',
                '-webkit-border-radius': '5px',
                '-moz-border-radius': '5px',
                opacity: .5,
                color: '#000'
            },
            overlayCSS: {
                opacity: .8
            },
            baseZ: 9000,
            theme: false,
            message: ""
        });

        $.fancybox.showLoading();
    },
    hideBusyBox: function () {
        $.unblockUI();
        $.fancybox.hideLoading();
    },
    showErrorMessage: function (error) {
        var errorLinks = null;
        var message = "";

        if (error && typeof (error) === 'object') {
            if (!error.IsApplicationException) {
                errorLinks = $("<p class='errorLinks' />").append($("<a href='#' />").html(sharedResources.ViewErrorDetails).click(function () {
                    var displayErrorDetailsResources = { "Title": sharedResources.ErrorDetails, "Message": "", "CancelButton": sharedResources.Close };
                    modalDialog.renderSimpleFormDialog(displayErrorDetailsResources, [{ Label: null, Name: "Items", Value: error.Trace, Type: "textarea", Style: "width:97%" }]);
                }), $("<a href='#' />").html(sharedResources.ReportError).click(function () {
                    modalDialog.showWindow(a4.baseUrl + 'Home/Contact/', 500, 500);
                }));
            }

            message = error.Message;
        }
        else {
            message = error;
        }

        $("<span class='standardMessage' />").html(_.unescape(message)).append(errorLinks).showAsNotificationMessage({ error: true });
    },
    showSuccessMessage: function (content, timeout) {
        $("<span class='standardMessage'>" + content + "</span>").showAsNotificationMessage({ timeout: timeout });
    },
    testSurvey: function (surveyToken) {
        window.open($("#SurveyEngineBaseUrl").val() + "Test/?st=" + surveyToken + '&tui=' + (new Date().getTime()), '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    takeSurvey: function (surveyToken) {
        window.open($("#SurveyEngineBaseUrl").val() + "?st=" + surveyToken + '&tui=' + (new Date().getTime()) + '&nocookie=', '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    previewSurvey: function (surveyToken) {
        window.open($("#SurveyEngineBaseUrl").val() + "Preview/?st=" + surveyToken + '&tui=' + (new Date().getTime()), '_blank', 'toolbar=0, location=1, menubar=0, resizable=1, scrollbars=1, width=1024, height=768');
    },
    absoluteRedirect: function (viewName) {
        window.location = a4.baseUrl + viewName;
    },
    getUrl: function (viewName) {
        return a4.baseUrl + viewName;
    },
    getAgentAction: function (pageUrl, methodName, params) {
        var url = pageUrl + "/" + methodName;
        if (a4.getQueryStringParams(params) !== "")
            url = "/" + a4.getQueryStringParams(params);
        return url;
    },
    getAction: function (action, controller, area, params) {
        var baseUrl = a4.baseUrl;

        if (area && area.toLowerCase() != "home")
            baseUrl += area + "/";

        return baseUrl + controller + "/" + action + "/" + a4.getQueryStringParams(params);
    },
    getSurveyAction: function (action, controller, params) {
        var surveyId = $("#SurveyId").val() || 0;

        if (params && params.surveyId) {
            surveyId = params.surveyId;
            delete params.surveyId;
        }

        return a4.baseUrl + "Survey/" + controller + "/" + action + "/" + surveyId + a4.getQueryStringParams(params);
    },
    getSurveyId: function () {
        return $("#SurveyId").val() || 0;
    },
    getProjectAction: function (action, controller, params) {
        var projectId = $("#ProjectId").val() || 0;

        if (params && params.projectId) {
            projectId = params.projectId;
            delete params.projectId;
        }

        return a4.baseUrl + "Project/" + controller + "/" + action + "/" + projectId + a4.getQueryStringParams(params);
    },
    getQueryStringParams: function (params) {
        var queryString = "";

        if (params) {
            var qsParams = _.map(params, function (val, key) { return key + "=" + encodeURIComponent(val); });

            if (qsParams && qsParams.length > 0)
                queryString = "?" + qsParams.join("&");
        }

        return queryString;
    },
    ie: function () {
        var undef, v = 3, div = document.createElement('div');

        while (
            div.innerHTML = '<!--[if gt IE ' + (++v) + ']><i></i><![endif]-->',
            div.getElementsByTagName('i')[0]
        );

        //check for IE7
        if (v <= 4 && navigator.appVersion.indexOf("MSIE 10.") != -1)
            v = 10;

        return v > 4 ? v : undef;
    },
    getTooltipQuestionText: function (autocomplete, tooltip, questionnaireId, questionId) {
        a4.callServerMethod(a4.getSurveyAction("GetQuestionText", "Questionnaire"), { questionnaireId: questionnaireId, questionId: questionId },
            function (result) {
                autocomplete.attr("title", result);
                if (tooltip != null)
                    tooltip.html(result).toggle(result != null && result != "");
            }
        );
    },
    readCookie: function (name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
        }
        return null;
    },
    setCookie: function (name, value, days) {
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            var expires = "; expires=" + date.toGMTString();
        }
        else var expires = "";
        document.cookie = name + "=" + value + expires + "; path=/";
    },
    getPageCookieName: function (version) {
        var pathName = window.location.pathname;
        var page = pathName.substring(pathName.indexOf('/') + 1);
        return "A4S_" + version + "_" + page;
    },
    disableEnter: function (e) {
        return (e.keyCode != 13);
    },
    fixPostForInput: function (selector) {
        $(selector).find(':input[type=text]:not(.enableEnter)').unbind('keypress.fixpost')
                                              .bind('keypress.fixpost', function (e) { return a4.disableEnter(e); });
    },
    setColorPickers: function (colorPickers, context) {
        var items = (colorPickers != null) ? colorPickers : $('.v-colorPicker', context);
        items = items.not(".v-setColorPicker");

        items.each(function () {
            var input = $(this);
            var container = $(this).parent();
            var startValue = container.find(".v-colorValue").val();

            if (startValue != "") {
                $(".color-display", container).css("background-color", startValue);
            }
            else {
                $(".color-display", container).css("background-color", "#ffffff");
            }

            function changeColorPickerValue(container, value) {
                var picker = $('#' + input.data('colorpickerId'), context)

                var containerItem = input.parent();

                // Validate the value against a regular expression to test validity
                if (/^([a-z]+|#[0-9a-f]{3}|#[0-9a-f]{6}|rgb\(\d{1,3},\d{1,3},\d{1,3}\)|rgba\(\d{1,3},\d{1,3},\d{1,3},0\.\d+\)|hsl\(\d{1,3},\d{1,3}\%,\d{1,3}\%\)|hsla\(\d{1,3},\d{1,3}\%,\d{1,3}\%\,0\.\d+\))$/i.test(value)) {
                    picker = $('#' + input.data('colorpickerId'), context)
                    picker.data('colorpicker').el.value = value;

                    $(".color-display", containerItem).css("background-color", value);
                    $(".v-colorValue", containerItem).val(value);
                }
                else {
                    $(".color-display", containerItem).css("background-color", "#ffffff");
                }
            }

            input.ColorPicker({
                color: (startValue != "") ? startValue : 'ffffff',
                inputField: input,
                container: context,
                onSubmit: function (hsb, hex, rgb, el) {
                    $(el).val("#" + hex);
                    $(el).ColorPickerHide();
                },
                onBeforeShow: function () {
                    if (this.value != null && this.value != "") {
                        $(this).ColorPickerSetColor(this.value);
                    }
                },
                onChange: function (hsb, hex, rgb, input) {
                    changeColorPickerValue(input.parent(), "#" + hex);
                }
            });

            $('.v-colorValue', $(this).parent()).change(function () {
                changeColorPickerValue($(this).parent(), $(this).val());
            });
        });

        items.addClass("v-setColorPicker");
    },
    clearInputValidation: function (input) {
        if (input.hasClass("input-validation-error")) {
            var inputName = input.attr("name");
            $("span.field-validation-error[data-valmsg-for='" + inputName + "']").addClass("field-validation-valid").removeClass("field-validation-error").text("");
            input.removeClass("input-validation-error");
        }
    },
    validateRequiredFields: function (context) {
        var errorMessage = resources.RequiredField;
        var requiredFields = $(".v-requiredField:visible", context);
        var isValid = true;

        requiredFields.each(function () {
            if ($.trim($(this).val()).length == 0) {
                isValid = false;
                var error = $("[data-valmsg-for='" + $(this).attr("name") + "']", context);

                $(this).addClass("input-validation-error");
                error.removeClass("field-validation-valid").addClass("field-validation-error").text(errorMessage);

                $(this).on("change", function () {
                    a4.clearInputValidation($(this));
                });
            }
        });

        return isValid;
    },
    validateEmail: function (email) {
        var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return filter.test(email);
    },
    validatePhone: function (phone) {
        //var filter = /^(0?(\d){9,10}|\+?1?\s?\(?(\+?[0-9]{3,5})\)?[-\s\.]{1}([0-9]{3})[-\s\.]{1}([0-9]{4}))$/;
        var filter = /^([(\-\s\.\+]*[0-9][)\-\s\.]*){8,15}$/;
        return filter.test(phone);
    },
    validateNumberKeyCode: function (event, allowNegative, value, maxLength) {
        // Allow backspace and delete
        // Ensure that it is a number and stop the keypress (0-9 are ascii code 48 to 57)
        if (!(event.which == 0 // For FireFox
                  || event.which == 46 || event.which == 8 || event.which == 45 || event.which == 9      // delete,  backspace, and tab
                  || (event.which == 109 && allowNegative)
                  || event.which == 37 || event.which == 39         // left and right arrow
                  || (event.which >= 48 && event.which <= 57)
                  || (event.which >= 96 && event.which <= 105))     // numberpad 0 to 9
            || ((value && maxLength)
                && (((48 <= event.which && event.which <= 57) || (96 <= event.which && event.which <= 105))
                    && (value.length + 1) > maxLength))) {
            event.preventDefault();
            return false;
        }

        return true;
    },
    countEmails: function (emails) {
        var count = 0
        if (emails.length > 0) {
            count = _.compact(emails.match(/@{1}[^\n,;\s]*[\n,;\s]?/g)).length;
        }
        return count;
    },
    countPhones: function (data) {
        var count = 0
        var phones = data.split("\n");

        _.each(phones, function (p) {
            if (p != "" && a4.validatePhone(p)) {
                count++;
            }
        })

        return count;
    },
    validateNameKeyCode: function (event) {
        // Allow backspace and delete
        if (!(event.which == 0 // For FireFox
                  || event.which == 8
                  || event.which == 32  // Space
                  || event.which == 45
                  || event.which == 95
                  || (event.which >= 48 && event.which <= 57)
                  || (event.which >= 65 && event.which <= 90)
                  || (event.which >= 97 && event.which <= 122)
            )) {
            event.preventDefault();
            return false;
        }

        return true;
    },
    validatePhone: function (value) {
        var exp = /[^(\d|\-)]/g;
        return value.replace(exp, '');
    },
    inIFrame: function (element) {
        var window = element ? a4.getElementWindow(element) : window;

        try {
            return window.self !== window.top;
        } catch (e) {
            return true;
        }
    },
    getIFrameTop: function () {
        var windowTop = null;

        for (var i = 0; windowTop == null && i < window.top.frames.length; i++) {
            try {
                var frame = window.top.frames[i];

                if (frame && frame.location && frame.location.host == window.location.host && frame.location.href.toLowerCase().indexOf(a4.baseUrl) == 0) {
                    windowTop = frame;
                }
            }
            catch (e) { }
        }

        return windowTop || window.self;
    },
    getElementWindow: function (element) {
        if (element.context && element.context.ownerDocument && element.context.ownerDocument.defaultView) {
            return element.context.ownerDocument.defaultView;
        }
        else {
            return window;
        }
    },
    top: function (element) {
        var windowTop = element ? a4.getElementWindow(element).top : window.top;
        try {
            if (window.self.location.host != windowTop.location.host || windowTop.location.href.toLowerCase().indexOf(a4.baseUrl) == -1) {
                windowTop = a4.getIFrameTop();
            }
        }
        catch (e) {
            windowTop = a4.getIFrameTop();
        }

        return windowTop;
    },
    parent: function (element) {
        var windowParent = element ? a4.getElementWindow(element).parent : window.parent;

        try {
            if (window.self.location.host != windowParent.location.host || windowParent.location.href.toLowerCase().indexOf(a4.baseUrl) == -1) {
                windowParent = window.self;
            }
        }
        catch (e) {
            windowParent = window.self;
        }

        return windowParent;
    },
    htmlEntityMap: {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': '&quot;',
        "'": '&#39;',
        "/": '&#x2F;'
    },
    escapeHtml: function (value) {
        return String(value).replace(/[&<>"'\/]/g, function (s) {
            return a4.htmlEntityMap[s];
        });
    },
    closeHtmlTags: function (html) {
        var openedtags = html.match(/<([^(\/|<)]+)>/g) //put all opened tags into an array
        var closedtags = html.match(/<\/([^>]+)>/g);

        if (_.size(openedtags) == _.size(closedtags)) {
            return html;
        }

        // Remove html
        var div = document.createElement("div");
        div.innerHTML = html;
        html = div.innerHTML;

        return html;
    },
    initializeInputs: function (context) {
        $(".h-autonumeric", context).autoNumeric({ aPad: false, vMin: '0', vMax: '99999999', mDec: '0', aSep: '' });
        $(".h-autonumericPercent", context).autoNumeric({ aPad: false, vMin: '0', vMax: '100', mDec: '0', aSep: '' });
        $(".h-datepicker", context).datepicker();
    },
    initializeDropDowns: function () {
        var lastOpened;

        var closeDropDown = function (dropDown) {
            dropDown.removeClass("open");
            dropDown.off("mouseenter");
            dropDown.off("mouseleave");

            $(document).off("click.dropdown");
        };

        $(document).on("click", ".button-group:has(.dropdown-menu), .mega-menu-toggle", function (e) {
            if (lastOpened && lastOpened[0] != $(this)[0]) {
                closeDropDown(lastOpened);
            }

            var timer;

            if (!$(this).hasClass("open")) {
                $(this).addClass("open");

                $(".dropdown-menu :input:first", $(this)).focus();

                $(this).on("mouseenter", function (e) {
                    if (timer)
                        window.clearTimeout(timer);
                });

                $(this).on("mouseleave", function (e) {
                    var self = $(this);
                    timer = window.setTimeout(function () {
                        closeDropDown(self);
                    }, 600);
                });

                $(document).on("click.dropdown", function (e) {
                    closeDropDown(lastOpened);

                    if (timer)
                        window.clearTimeout(timer);

                    e.stopPropagation();
                });
            }
            else {
                closeDropDown($(this));

                if (timer)
                    window.clearTimeout(timer);
            }

            lastOpened = $(this);

            e.stopPropagation();
        });

        $(document).on("click", ".button-group .dropdown-menu.keep-open", function (e) {
            e.stopPropagation();
        });
    },
    setInputFocus: function (context) {
        $("input:text, textarea", context).not("[disabled],[readonly]").first().focus();
    },
    conditionEvaluatorRegEx: /\[(.+?)\]/g,
    evaluateCondition: function (condition, data) {
        var valid = true;

        if (typeof (condition) != 'undefined' && condition != null) {
            try {
                if (typeof condition === "boolean") {
                    valid = condition;
                }
                else if (typeof condition === "string") {
                    var expression = condition.replace(a4.conditionEvaluatorRegEx, function (match, capture) {
                        return _.isString(data[capture]) ? "'" + data[capture] + "'" : data[capture];
                    });

                    valid = eval(expression);
                }
                else { //Legacy
                    var anyVisible = false;
                    var allVisible = false;
                    var anyConditions = condition.Any;
                    var everyConditions = condition.Every;

                    if (anyConditions == undefined && everyConditions == undefined) {
                        if (_.isArray(condition)) {
                            everyConditions = condition;
                        }
                        else {
                            everyConditions = [];
                            everyConditions.push(condition);
                        }
                    }

                    if (anyConditions) {
                        anyVisible = _.some(anyConditions, function (f) {
                            if (typeof f === "boolean") return f;
                            else if (_.isArray(f.Value)) return _.contains(f.Value, data[f.Property]);
                            else return data[f.Property] == f.Value;
                        });
                    }

                    if (everyConditions) {
                        allVisible = _.every(everyConditions, function (f) {
                            if (typeof f === "boolean") return f;
                            else if (_.isArray(f.Value)) return _.contains(f.Value, data[f.Property]);
                            else return data[f.Property] == f.Value;
                        });
                    }

                    valid = allVisible || anyVisible;
                }
            }
            catch (ex) {
                if (console)
                    console.error(ex);
            }
        }

        return valid;
    },
    showSelectProjectDialog: function (callback, title, hideProjectId) {
        if (!hideProjectId)
            hideProjectId = $("#ProjectId").val() || 0;

        modalDialog.showWindow(a4.getProjectAction("SelectProject", "Shared", { title: title || "", hideProjectId: hideProjectId }), 300, 600, {
            afterClose: function () {
                var topWindow = a4.top();
                if (topWindow.selectedProjectId) {
                    callback(topWindow.selectedProjectId);
                    topWindow.selectedProjectId = undefined;
                }
            }
        });
    },
    formatDate: function (date) {
        return $.datepicker.formatDate(dateFormat, date);
    },
    updateUnreadMessagesCount: function () {
        var messagesCountContainer = $("#menu-bar .action.messages .messages-count");

        a4.callServerMethod(a4.getAction("GetUnreadMessagesCount", "Shared", "Home"), {},
            function (result) {
                if (result == 0) {
                    if (messagesCountContainer.length > 0) {
                        messagesCountContainer.hide();
                    }
                }
                else {
                    if (messagesCountContainer.length == 0) {
                        $("#menu-bar .action.messages .fa-envelope").append($("<span />", { "class": "messages-count" }).append(result));
                    }
                    else {
                        messagesCountContainer.text(result);
                    }
                }
            }
        )
    }

};

//---------------------------- JQuery Plugins

jQuery.fn.outerHTML = function () {
    return $('<div>').append(this.eq(0).clone()).html();
};

(function ($) {
    var check = false, isRelative = true;

    $.elementFromPoint = function (x, y) {
        if (!document.elementFromPoint) return null;

        if (!check) {
            var sl;
            if ((sl = $(document).scrollTop()) > 0) {
                isRelative = (document.elementFromPoint(0, sl + $(window).height() - 1) == null);
            }
            else if ((sl = $(document).scrollLeft()) > 0) {
                isRelative = (document.elementFromPoint(sl + $(window).width() - 1, 0) == null);
            }
            check = (sl > 0);
        }

        if (!isRelative) {
            x += $(document).scrollLeft();
            y += $(document).scrollTop();
        }

        return document.elementFromPoint(x, y);
    }
})(jQuery);

(function ($) {
    $.fn.inlineStyle = function (prop) {
        return this.prop("style")[$.camelCase(prop)];
    };
}(jQuery));

(function ($) {
    $.fn.isBound = function (type, fn) {
        var data = $._data(this, 'events');

        if (data === undefined || data.length === 0) {
            return false;
        }

        data = data[type];

        if (data === undefined || data.length === 0) {
            return false;
        }

        return (-1 !== $.inArray(fn, data));
    };
}(jQuery));

(function ($) {
    $.fn.preventDoubleSubmission = function () {
        $(this).on('submit', function (e) {
            var $form = $(this);

            if ($form.data('submitted') === true) {
                // Previously submitted - don't submit again
                e.preventDefault();
            } else {
                // Mark it so that the next submit can be ignored
                $form.data('submitted', true);
            }
        });

        // Keep chainability
        return this;
    };
})(jQuery);

//---------------------------- JQuery Extensions

$(document).ready(function () {
    // auto bind dialog for upper menu user account
    //modalDialog.autoBind("accountLink", 550, 650);
    //modalDialog.autoBind("adminAccount", 350, 600);
    //modalDialog.autoBind("contactSupportLink", 475, 475);

    //Cancel click in disabled buttons
    $(document).on("click", "button[disabled]", function (event) {
        event.preventDefault();
        event.stopPropagation();
    });

    //Cancel click in disabled hyperlinks
    $(document).on("click", "a", function (e) {
        if ($(this).prop("disabled") || $(this).attr("disabled") == "disabled") {
            e.preventDefault();
            e.stopPropagation();
        }
    });

    //Setting the language for datepickers
    var lang = $("html").attr("lang");
    $.datepicker.setDefaults($.datepicker.regional[lang]);
    $.timepicker.setDefaults($.timepicker.regional[lang]);

    //Setting base url
    a4.baseUrl = "";// $("#ApplicationBaseUrl").val().toLowerCase();

    a4.host = window.location.protocol + '//' + window.location.hostname;

    //a4.initializeDropDowns();

    //Preventing double submission for all forms
    $("form").preventDoubleSubmission();

    //Prompt when leaving page
    //$("form").on("click", ".h-reloadFormButton", function (e) {
    //    window.location = window.location;
    //});

    //$("form.validate-save").a4unsavedChanges({
    //    change: function (event, data) {
    //        var buttons = $(this).find(".h-reloadFormButton, :submit");

    //        if (data.hasChanges) {
    //            buttons.removeAttr("disabled");
    //        }
    //        else {
    //            buttons.attr("disabled", "disabled");
    //        }
    //    }
    //});

    //$(document).tooltip({
    //    position: { my: "center top+5", at: "center bottom" }
    //});
});
